package apps.conf;


import java.util.*;
import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import cnrg.itx.signal.*;
import cnrg.itx.signal.SignalEvent.*;
import cnrg.itx.ds.*;
import java.io.*;


import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
	
/**
 * Class for building and maintianing conferences.<p><p> 
 * For performance reasons, all network connections are made with FEC and RTP turned off
 */
public class Conference {
	
	/** Contains all of the ConnectionManagers associated with this conference.
	 */
	private Vector connections = null;
	/** Contains the mixer responsible for combining the inputs to the conference.
	 */
	private MixerChannel mixer = null;
	/** The login ID of the conference
	 */
	private String uid = "conf0";
	/** The login password for the conference
	 */
	private String pass = "conf0";
	/** The Topic for this conference
	 */
	private String topic = "none";
	/** The name of the conference
	 */
	private String confName = "Conference";
	
	/** The user interface	 */
	private static ConfUI ui = null;

	
	
	public static void main( String args[] ) {
	
		try {
			//System.out.println("Building UI...");
			
			//Conference co = new Conference("conf0","conf0","Testing Conference");
			ui= new ConfUI();
			//co.open();		

		}catch (Exception e){e.printStackTrace();}
	}
	
	/**
	 * Builds a new conference. This constructor allows the specification of
	 * a conference name and topic. This method also init's the mixer object within the conference.
	 * @param username Login name for conference
	 * @param password Login password for conference
	 * @param topic Topic to be listed in directory entry
	 */
	public Conference(String username, String password, String topic) {
		this();
		this.uid = username;
		this.pass = password;
		this.topic = confName+": "+topic;
	}
		
		
	/**
	 * Builds a new conference. This constructor uses a default name and topic.
	 * This method also init's the mixer object within the conference.
	 */
	public Conference()  {
		connections = new Vector();
		mixer = new MixerChannel();
	}
	
	/**
	 * Starts the conference. Opens the Conference's mixer.
	 */
	public void open() throws DataException {
		mixer.open();
	}
	
	/**
	 * Invites a participant to the conference. Participant is dialed via non-blocking dial.
	 * @param participant the uid of the person to dial
	 * @exception DirectoryServiceException thrown when participant is not reachable.
	 */
	public void add(String participant) throws DirectoryServiceException {
		//synchronized (connections) {
			ConnectionManager cm = new ConnectionManager(this, uid,pass,topic);
			cm.dial(participant, false);
			connections.addElement(cm);
		//}
	}
	
	/**
	 * Adds a channel for accepting incoming calls. Once a call is recieved, an another recieving
	 * channel will be added to accept additional calls.
	 */
	public void addAcceptor() {
		//synchronized (connections) {
		
			ConnectionManager cm = new ConnectionManager(this, uid,pass,topic);
			//TODO: make sure we deal with wrong uid, pass...
		
			connections.addElement(cm);
			cm.recieve(false);
			cm.hasChanged();
			cm.notifyObservers();
		//}
		
	}
	
	/**
	 * Remove a connectionManager from the conference's listing. Closes
	 */
	public void remove(ConnectionManager cm) {
		//synchronized (connections) {
			cm.close();
			connections.removeElement(cm);
		//}
	}
	
	/**
	 * Closes all of the connections within the Conference, then halts the mixer.
	 */
	public void close() {

		while (!connections.isEmpty()) {
			((ConnectionManager)connections.firstElement()).close();
		}
		connections.removeAllElements();
		//if (mixer != null) 
			mixer.close();
		try {
			DirectoryService ds = new DirectoryService();
			ds.setCleanUp(false);
			ds.declareIdentity(new UserID(uid), new Password(pass));
			ds.setCustomMessage(confName+": offline");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Returns the sound sourcing object for the conference.
	 * @return MixerChannel the mixer object of this conference
	 */
	public MixerChannel getMixer() {
		return mixer;
	}
		 
	public Vector getParticipants() {
		return connections;
	}
	
	public ConfUI getUI() {
		return ui;
	}
	
}





		
